﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace PowerAmpDemoNS
{
    public partial class TestPlan_SFP : Form
    {
        public PowerAmpDemoProgram TestProgram;
        private bool updating;

        public TestPlan_SFP(PowerAmpDemoProgram myTestProgram)
        {
            InitializeComponent();
            TestProgram = myTestProgram;
            updateGuiControls();
            // Init the Spectrum Graph
            spectrumChart.Series.Clear();
            spectrumChart.Series.Add("ACPR1L");
            spectrumChart.Series["ACPR1L"].ChartType = System.Windows.Forms.DataVisualization.Charting.SeriesChartType.Line;
            spectrumChart.Series.Add("ACPR1U");
            spectrumChart.Series["ACPR1U"].ChartType = System.Windows.Forms.DataVisualization.Charting.SeriesChartType.Line;
            bandwidthBox.SelectedIndex = 0;
        }

        private const int CP_NOCLOSE_BUTTON = 0x200;
        protected override CreateParams CreateParams
        {
            get
            {
                CreateParams myCp = base.CreateParams;
                myCp.ClassStyle = myCp.ClassStyle | CP_NOCLOSE_BUTTON;
                return myCp;
            }
        }

        private void updateGuiControls()
        {
            updating = true;
            iqDelayControl.Value = (decimal)(TestProgram.iqDelay * 1e9);
            iqRangeControl.Value = (decimal)(TestProgram.iqRange * 1e9);
            iqStepControl.Value = (decimal)(TestProgram.iqStep * 1e9);
            freqIndexControl.Value = (decimal)(TestProgram.frequencyIndex);
            arbGainControl.Value = (decimal) TestProgram.arbAmplitude;
            arbOffsetControl.Value = (decimal)TestProgram.arbOffset;

            Application.DoEvents();
            updating = false;
        }

        private void readGuiControls(object sender, EventArgs e)
        {
            if (!updating)
            {
                TestProgram.iqDelay = (double) iqDelayControl.Value / 1e9;
                TestProgram.iqRange = (double) iqRangeControl.Value/ 1e9;
                TestProgram.iqStep = (double) iqStepControl.Value / 1e9;
                TestProgram.frequencyIndex = (int) freqIndexControl.Value;
                TestProgram.arbAmplitude = (double)arbGainControl.Value;
                TestProgram.arbOffset = (double)arbOffsetControl.Value;
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Cursor.Current = Cursors.WaitCursor;
            TestProgram.dataLog.testIndex = 0;

            switch ((string)bandwidthBox.SelectedItem)
            {
                case "5 MHz":
                    {
                        TestProgram.lteEtTest("B5M");
                        break;
                    }
                case "10 MHz":
                    {
                        TestProgram.lteEtTest("B10M");
                        break;
                    }
                case "20 MHz":
                    {
                        TestProgram.lteEtTest("B20M");
                        break;
                    }
            }

                    
            spectrumChart.Series["ACPR1L"].Points.Clear();
            spectrumChart.Series["ACPR1U"].Points.Clear();
            double startIqDelay = Math.Max((TestProgram.iqDelay - TestProgram.iqRange), -250e-9);
            double stopIqDelay = Math.Min((TestProgram.iqDelay + TestProgram.iqRange), 250e-9);
            int numPoints = (int)((stopIqDelay - startIqDelay) / TestProgram.iqStep) + 1;
            for (int j = 0; j < numPoints; j++)
            {
                spectrumChart.Series["ACPR1L"].Points.AddXY(startIqDelay + j * TestProgram.iqStep, TestProgram.dataLog.measAcpr[j, 0]);
                spectrumChart.Series["ACPR1U"].Points.AddXY(startIqDelay + j * TestProgram.iqStep, TestProgram.dataLog.measAcpr[j, 1]);
            }
            //spectrumChart.ChartAreas[0].AxisY.Maximum = -30;
            Application.DoEvents();
            Cursor.Current = Cursors.Default;
        }
    }
}
